#include "CStone.h"

#ifndef def_cstones                          //   C:\My Documents\Allegro Projects\curlingC:\My Documents\Allegro Projects\curling
#define def_cstones

/*typedef struct
{
    int s1,s2; //stone 1, stone 2 and the time of the collision
    float t;
} collision; */

class CStones
{
public:
    CStone stone[17];   //there are a max of 16 urling stones in a game
    int next_stone;

    void init_all(void);
    void create_stone(int n, float x, float y, BITMAP *pic, int owner);
    void create_stone(float x, float y, BITMAP *pic, int owner);
    void draw_all(BITMAP *backgr, float s_x, float s_y);
    void draw_all(BITMAP *backgr, float s_x, float s_y, float w, float h);
    int move_all(float friction, Point *screen_pos);
    void destroy_all(void);
    int are_any_moving(void);
    void check_all_bounds(int x);
};

void CStones::check_all_bounds(int x)
{
    for(int n=0 ; n<next_stone ; n++)
        {
        stone[n].check_bounds(x);
        }
}

int CStones::are_any_moving(void)
{
    //int ret=0;
    /*for(int n=0 ; n<17 ; n++)
        {
        if(stone[n].is_moving()==1)
            {
            return 1;
            }
        }
    return 0;*/
    for(int n=0 ; n<17 ; n++)
        {
        if(stone[n].is_moving()==1)
            return 1;       //if any are moving, return 1
        }
    return 0;      //if none are moving return 0
}

void CStones::destroy_all(void)
{
    for(int n=0 ; n<17 ; n++)
        stone[n].destroy_stone();
}

int CStones::move_all(float friction, Point *screen_pos)
{
    int num=0;
    int ret=0;
    float iTime;
    for(int n3=0 ; n3<2 ; n3++)
        {
        for(int n=0 ; n<17 ; n++)
            {
            for(int n2=0 ; n2<17 ; n2++)
                {
                if(n!=n2)
                    {
                    stone[n].check_coll_with_stone(&stone[n2]);

                    }
                }
            //stone[n].move_stone(friction,screen_pos);
            }

        }

    for(int n=0 ; n<17 ; n++)
        {
        if(stone[n].move_stone(friction,screen_pos)==1)
            ret=1;
        }

    return ret;

}

void CStones::draw_all(BITMAP *backgr, float s_x, float s_y)
{
    for(int n=0 ; n<17 ; n++)
        stone[n].draw_stone(backgr, s_x, s_y);
}

void CStones::draw_all(BITMAP *backgr, float s_x, float s_y, float w, float h)
{
    for(int n=0 ; n<17 ; n++)
        stone[n].draw_stone(backgr, s_x, s_y, w, h);
}

void CStones::create_stone(int n, float x, float y, BITMAP *pic, int owner)
{
    if(n>=0 && n<17)
        stone[n].create_stone(x,y,pic,owner);
}

void CStones::create_stone(float x, float y, BITMAP *pic, int owner)
{
    if(next_stone<17)
        {
        stone[next_stone].create_stone(x,y,pic,owner);
        next_stone++;
        }
}

void CStones::init_all(void)
{
    next_stone=0;
    for(int n=0 ; n<17 ; n++)
        {
        stone[n].init_stone();
        }
}


#endif
